/****** Object:  StoredProcedure [dbo].[P_EST_PROD_CUSTO_ACERTO_PELO_PRECO_VENDAS]    Script Date: 03/12/2014 09:44:32 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CUSTO_ACERTO_PELO_PRECO_VENDAS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CUSTO_ACERTO_PELO_PRECO_VENDAS]
GO
GO
GO
--EXEC P_EST_PROD_CUSTO_ACERTO_PELO_PRECO_VENDAS '2015-12-01',60,0,2015,12
CREATE PROCEDURE P_EST_PROD_CUSTO_ACERTO_PELO_PRECO_VENDAS @DT_PROC_AGENDA DATETIME,
														   @PERC_CUSTO_DA_VENDA MONEY,
														   @CD_FILIAL_PAR INT,
														   @ANO_FECHA INT, 
														   @MES_FECHA INT
AS
SET NOCOUNT ON
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PROD INT
DECLARE @VLR_CUSTO_MD MONEY

SET @PERC_CUSTO_DA_VENDA = (@PERC_CUSTO_DA_VENDA/100)

IF @MES_FECHA=0
begin
DECLARE CEstProdCustoMedio CURSOR FAST_FORWARD FOR 
	select
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_PROD,
		ROUND((ISNULL(pr.VLR_TABELA,0) * @PERC_CUSTO_DA_VENDA),2) AS VLR_CUSTO_MD
	from
		est_prod_cpl p left outer join est_prod_preco pr on
		p.cd_emp = pr.cd_emp and
		p.cd_filial = pr.cd_filial and
		p.cd_prod = pr.cd_prod 
	where
		p.cd_emp=1
		and (p.vlr_custo_md=0
		or p.vlr_custo=0)
		and (not pr.VLR_TABELA is null AND VLR_TABELA >0)
	    and p.CD_FILIAL=CASE WHEN @CD_FILIAL_PAR = 0 THEN p.CD_FILIAL ELSE @CD_FILIAL_PAR END 
	ORDER BY
		p.CD_FILIAL,
		p.CD_PROD		
end

IF @MES_FECHA<>0
begin
DECLARE CEstProdCustoMedio CURSOR FAST_FORWARD FOR 
	select
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_PROD,
		ROUND((ISNULL(pr.VLR_TABELA,0) * @PERC_CUSTO_DA_VENDA),2) AS VLR_CUSTO_MD
	from
		EST_FECHA p left outer join est_prod_preco pr on
		p.cd_emp = pr.cd_emp and
		p.cd_filial = pr.cd_filial and
		p.cd_prod = pr.cd_prod 
	where
		p.cd_emp=1
		and (p.vlr_custo_md=0
		or p.vlr_custo=0)
		and (not pr.VLR_TABELA is null AND VLR_TABELA >0)
		and p.ANO_FECHA = @ANO_FECHA
		and p.MES_FECHA = @MES_FECHA
		AND p.CD_FILIAL=CASE WHEN @CD_FILIAL_PAR = 0 THEN p.CD_FILIAL ELSE @CD_FILIAL_PAR END 
	ORDER BY
		p.CD_FILIAL,
		p.CD_PROD		
end
		
OPEN CEstProdCustoMedio
FETCH NEXT FROM CEstProdCustoMedio INTO @CD_EMP, @CD_FILIAL,@CD_PROD,@VLR_CUSTO_MD
	WHILE @@FETCH_STATUS=0
	  begin
		PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' Produto.: ' + CONVERT(VARCHAR, @CD_PROD) 
		EXEC P_EST_PROD_CUSTO_ACERTO_REPLICACAO @CD_EMP,
												@CD_FILIAL,
												@CD_PROD,
												@DT_PROC_AGENDA,
												@VLR_CUSTO_MD,
												1,
												0
		FETCH NEXT FROM CEstProdCustoMedio INTO @CD_EMP, @CD_FILIAL,@CD_PROD,@VLR_CUSTO_MD
	  end

PRINT 'Concluido.'
CLOSE CEstProdCustoMedio;
DEALLOCATE CEstProdCustoMedio;

